/* zobrazeni polohy telesa na kruhove mape */

var SkyView =
    {
    icon:"../gfx/skyviewIcon.png", 
    caption:"poloha na obloze", 

    help: "Orientační <b>zobrazení polohy objektu na mapě oblohy</b> spolu se Sluncem a Měsícem (<i>tam kde to dává smysl</i>). Poklikem na tabulku <b>zafixujete</b> daný řádek.",


    parameters:""
    };
    
SkyView.content=function () 
    {
    return '\
            <img src="../gfx/skyview.png" border="0" width="400" height="400" alt="otacivka"> \
            <img id="SkyViewSun" src="../gfx/sun.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:15px;left:30px"> \
            <img id="SkyViewMoon" src="../gfx/moon.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:15px;left:60px;"> \
            <img id="SkyViewTarget" src="../gfx/target.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:15px;left:90px;"> \
            ';
    
    
    }


// ODKAZY NA ELEMENTY
SkyView.sun = null;
SkyView.moon = null;
SkyView.target = null;


// CORE
SkyView.D=400;
SkyView.setPos =function (target,ra,dec)
    {
    target.style.left = (SkyView.D/2 + SkyView.D/260*(90-dec)*Math.cos(ra*Math.PI/180)).toString()+'px';
    target.style.top =  (SkyView.D/2 + SkyView.D/260*(90-dec)*Math.sin(ra*Math.PI/180)).toString()+'px';
    }
  
// HANDLERS
SkyView.onShow=function () 
    {
    SkyView.sun = document.getElementById('SkyViewSun'); 
    SkyView.moon = document.getElementById('SkyViewMoon'); 
    SkyView.target = document.getElementById('SkyViewTarget'); 
    
    SkyView.moon.style.display = (SkyView.parameters.showMoon)?"block":"none";
    SkyView.sun.style.display = (SkyView.parameters.showSun)?"block":"none";
    }

SkyView.onHide=function () {} 

SkyView.interactionHandler=function (sender,type) //fukce co se volá pro interakci s tabulkou
    {
    switch(type)
        {
        case 1: // onMouseOver
            {
            // sunmoon
            sm = sender.getAttribute('sunmoon');
            this.setPos(SkyView.sun,eval(sm.substr(0,3)),eval(sm.substr(3,3)));
            this.setPos(SkyView.moon,eval(sm.substr(6,3)),eval(sm.substr(9,3)));

            // nasati dat
            var r = Number(sender.getAttribute('id').substring(1)); // id radky je ve formatu r00
            var par = this.parameters;
            var format = this.parameters.format;
            var ra  = decode(document.getElementById('c'+r+'_'+par.raCol).innerHTML,par.raFormat);
            var dec = decode(document.getElementById('c'+r+'_'+par.decCol).innerHTML,par.decFormat);
            this.setPos(SkyView.target,ra*15,dec);

            break;
            }
        
        }


    } 

