
var clickOnce = {

    dialog_onload: function()
    {
        // This is the function that would have been called had our overlay not stepped in.
        dialog.initDialog();

        if (this.isClickOnce())
        {
            this.prefs = Components.classes["@mozilla.org/preferences-service;1"]
                     .getService(Components.interfaces.nsIPrefService)
                     .getBranch("microsoft.CLR.clickonce.");

            if (this.prefs.getBoolPref("autolaunch"))
            {
                this.launch_application();
            }
            else
            {
                var button = dialog.dialogElement("launchApplicationButton");
                button.collapsed = false;
                // If the user has both this addon and FFClickOnce installed show only our button
                var ffClickOnceButton = dialog.dialogElement("FFClickOnce-runbutton");
                if (ffClickOnceButton)
                {
                    ffClickOnceButton.collapsed = true;
                }

                // Let the dialog know it must resize to accommodate the new button
                dialog.mDialog.sizeToContent(); 
            }
        }
    },


    isClickOnce: function()
    {
        var mimeInfo = dialog.mLauncher.MIMEInfo;
        
        // Checking the file extension may be second guessing the webserver
        // but when 'prompt' is set the user will still have a save button.
        if (mimeInfo.MIMEType == "application/x-ms-application" ||
            mimeInfo.primaryExtension == "application")
        {
            return true;
        }

        return false;
    },


    launch_application: function()
    {
        this.execute(this.getPresentationHostLocation(), "-LaunchApplication " + dialog.mLauncher.source.spec);

        dialog.mDialog.close();
    },

    getPresentationHostLocation: function()
    {
        var nsIProperties = Components.classes["@mozilla.org/file/directory_service;1"]
                            .getService(Components.interfaces.nsIProperties)

        // Attempting to forward-proof this extension by testing for where PresentationHost
        // will probably be for CLR 4
        var phNewLoc64 = nsIProperties.get("WinD", Components.interfaces.nsILocalFile);
        phNewLoc64.appendRelativePath("Microsoft.NET\\Framework64\\wpf\PresentationHost.exe");
        if (phNewLoc64.exists())
        {
            return phNewLoc64;
        }

        var phNewLoc32 = nsIProperties.get("WinD", Components.interfaces.nsILocalFile);
        phNewLoc32.appendRelativePath("Microsoft.NET\\Framework\\wpf\PresentationHost.exe");
        if (phNewLoc32.exists())
        {
            return phNewLoc32;
        }

        // Fallback to the default location
        var phOldLoc   = nsIProperties.get("SysD", Components.interfaces.nsILocalFile);
        phOldLoc.appendRelativePath("PresentationHost.exe");
        return phOldLoc; 
    },

    execute: function(exe, strArgs)
    {
        // exe should already be an nsILocalFile

        // create an nsIProcess
        var process = Components.classes["@mozilla.org/process/util;1"]
                                .createInstance(Components.interfaces.nsIProcess);
        process.init(exe);

        // Run the process.
        // If first param is true, calling thread will be blocked until
        // called process terminates.
        // Second and third params are used to pass command-line arguments
        // to the process.
        var args = strArgs.split(" ");
        process.run(false, args, args.length);

    }

}
