/* přepočet časů východu, západu a průchodu pro jinou geografickou polohu */


var Occult =
    {
    icon:"../gfx/occultIcon.png", 
    caption:"okamžik<br>zákrytu", 

    help: "Přibližný <b>přepočet okamžiku zákrytu</b> vzhledem k zeměpisné poloze. Polohu zvolte poklikem na mapu. Poklikem na tabulku <b>zafixujete</b> daný řádek.",

    
    phiField: null,      // policka pro zobrazeni souradnic
    lambdaField: null,

    timeFieldPRG: null,  // okamzik zakrytu pole+promenna
    timeFieldVAL: null,  // okamzik zakrytu pole+promenna
    timePRG: -1,
    timeVAL: -1,
    
    latLine: null,
    longLine: null,
    map: null,

    parameters:""
        // riseCol,topCol,setCol ~ sloupce tabulky ve kterých jsou data
        // azCol ~ sloupec s azimutem (západu) ... není-li definován (=0) používá se algoritmus bez azimutu
        // formatRS ~ formát dat západu a východu (viz. dencoder)
        // formatT ~ formát dat průchodu (viz. dencoder)

    };
    
// OBSAH
Occult.content=function () 
    {
    var out = '<div id="occult">';
    out += '<div class="title">Okamžik zákrytu</div>';
    out+='<div><img src="../gfx/horizon2.png" border="0" width="330" height="99"></div>\n';
    out+='<div id="occultMap">';
    out+='<div align="center" style="position:absolute;top:-90px;left:130px;color:white;"><div>Reference&nbsp;Praha:</div><div class="fields" id="timePRG">-- --</div>\n';
    out+='<div>Reference&nbsp;Val.&nbsp;Meziříčí:</div><div class="fields" id="timeVAL">-- --</div></div>\n';
    out+='<div class="coords">&phi;=<span id="occultPhi">50</span>&deg;&nbsp;&nbsp;&nbsp;&lambda;=<span id="occultLambda">15</span>&deg;</div>\n';
    out+='<img  src="../gfx/map.gif" border="0" width="330" height="220" onclick="Occult.mapClick(event);">\n';
    out+='<img id="occultLatLine" src="../gfx/latLine.gif" border="0" width="330" height="1">\n';
    out+='<img id="occultLongLine" src="../gfx/latLine.gif" border="0" width="1" height="220">\n';
    out+="</div>\n";
    out+="</div>\n";
    return out;
    }



    
// aktualizace zobrazeni
Occult.refresh = function()
    {
    var oTimePRG = NaN;
    var oTimeVAL = NaN;
    
    var lambdaPRG = 14.4;
    var phiPRG = 50.08;
    var lambdaVAL = 17.98;
    var phiVAL = 49.46;
    
    if(Occult.time!=-1) // pokud jeste nebyl zvolen radek tabulky nic nepocitej
    {
    // vypocet hodnot
    
    oTimePRG = Normalize(this.timePRG + (this.aPRG * (this.lambda-lambdaPRG) + this.bPRG * (this.phi-phiPRG))/60,24);
    oTimeVAL = Normalize(this.timeVAL + (this.aVAL * (this.lambda-lambdaVAL) + this.bVAL * (this.phi-phiVAL))/60,24);

    }
    


    // zapsani do policek
    Occult.timeFieldPRG.innerHTML = encode(oTimePRG,this.parameters.formatT);
    Occult.timeFieldVAL.innerHTML = encode(oTimeVAL,this.parameters.formatT);
//    Occult.timeFieldPRG.innerHTML = oTimeVAL;
    
    }
    
    
// mysovite HANDLERY
Occult.mapClick = function(event) // click ~ urceni pozice v mape
    {
    var x = 0;
    var y = 0;
    
    // urceni pozice
    if(event.offsetX)
        { // MSIE, Opera
        x = event.offsetX;
        y = event.offsetY;
        }
        else
        { // Firefox
        pos = getElementAbsolutePos("occultMap"); 

        x = event.pageX-pos.x;
        y = event.pageY-pos.y;
        
        x = x - window.pageXOffset;
        y = y - window.pageYOffset;
        
        }
    
    x--;
    y--;
    
    // kriz
    Occult.longLine.style.left = x.toString()+'px';
    Occult.latLine.style.top = y.toString()+'px';
    
    // souradnice
        // rozmery mapy 330x220px
        // rozsahy lat = 48.27-51.35    long=11.86-19.11
        // meritko lat: 0.014 deg/pixel  long: 0.021 deg/pixel
    Occult.phi = 51.35-(y*0.014);
    Occult.lambda = (x*0.021)+11.86;
    
    Occult.phiField.innerHTML = Occult.phi.toFixed(2);
    Occult.lambdaField.innerHTML = Occult.lambda.toFixed(2);
    
    Occult.refresh();
    }
    
    
  
// module HANDLERY
Occult.onShow=function ()
    {

    this.timeFieldPRG = document.getElementById('timePRG');
    this.timeFieldVAL = document.getElementById('timeVAL');

    this.phiField = document.getElementById('occultPhi');
    this.lambdaField = document.getElementById('occultLambda');

    this.latLine = document.getElementById('occultLatLine');
    this.longLine = document.getElementById('occultLongLine');

    this.map = document.getElementById('occultMap');

    // init
    this.phi = 50;
    this.lambda = 15;
    
    Occult.longLine.style.left = '149px';
    Occult.latLine.style.top = '97px';

    }

Occult.onHide=function ()
    {
    } 

Occult.interactionHandler=function (sender,type)
    {
    // reset
    this.timePRG = 0;
    this.timeVAL = 0;

    var r = Number(sender.getAttribute('id').substring(1)); // id radky je ve formatu r00

     
     // nasati dat
    var par = this.parameters;
    this.timePRG = decode(document.getElementById('c'+r+'_'+par.prgCol).innerHTML,par.formatT);
    this.aPRG = decode(document.getElementById('c'+r+'_'+par.prgA).innerHTML,par.formatAB);
    this.bPRG = decode(document.getElementById('c'+r+'_'+par.prgB).innerHTML,par.formatAB);
    this.timeVAL = decode(document.getElementById('c'+r+'_'+par.valCol).innerHTML,par.formatT);
    this.aVAL = decode(document.getElementById('c'+r+'_'+par.valA).innerHTML,par.formatAB);
    this.bVAL = decode(document.getElementById('c'+r+'_'+par.valB).innerHTML,par.formatAB);
    // vykresleni
    this.refresh();
     
    } 

    
    
/* =========================== get element position ======================== */
/* by Sergiy Korzh, http://blogs.korzh.com */

function __getIEVersion() {
    var rv = -1; // Return value assumes failure.
    if (navigator.appName == 'Microsoft Internet Explorer') {
        var ua = navigator.userAgent;
        var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null)
            rv = parseFloat(RegExp.$1);
    }
    return rv;
}

function __getOperaVersion() {
    var rv = 0; // Default value
    if (window.opera) {
        var sver = window.opera.version();
        rv = parseFloat(sver);
    }
    return rv;
}

var __userAgent = navigator.userAgent;
var __isIE =  navigator.appVersion.match(/MSIE/) != null;
var __IEVersion = __getIEVersion();
var __isIENew = __isIE && __IEVersion >= 8;
var __isIEOld = __isIE && !__isIENew;

var __isFireFox = __userAgent.match(/firefox/i) != null;
var __isFireFoxOld = __isFireFox && ((__userAgent.match(/firefox\/2./i) != null) || (__userAgent.match(/firefox\/1./i) != null));
var __isFireFoxNew = __isFireFox && !__isFireFoxOld;

var __isWebKit =  navigator.appVersion.match(/WebKit/) != null;
var __isChrome =  navigator.appVersion.match(/Chrome/) != null;
var __isOpera =  window.opera != null;
var __operaVersion = __getOperaVersion();
var __isOperaOld = __isOpera && (__operaVersion < 10);

function __parseBorderWidth(width) {
    var res = 0;
    if (typeof(width) == "string" && width != null && width != "" ) {
        var p = width.indexOf("px");
        if (p >= 0) {
            res = parseInt(width.substring(0, p));
        }
        else {
             //do not know how to calculate other values (such as 0.5em or 0.1cm) correctly now
            //so just set the width to 1 pixel
            res = 1; 
        }
    }
    return res;
}


//returns border width for some element
function __getBorderWidth(element) {
    var res = new Object();
    res.left = 0; res.top = 0; res.right = 0; res.bottom = 0;
    if (window.getComputedStyle) {
        //for Firefox
        var elStyle = window.getComputedStyle(element, null);
        res.left = parseInt(elStyle.borderLeftWidth.slice(0, -2));  
        res.top = parseInt(elStyle.borderTopWidth.slice(0, -2));  
        res.right = parseInt(elStyle.borderRightWidth.slice(0, -2));  
        res.bottom = parseInt(elStyle.borderBottomWidth.slice(0, -2));  
    }
    else {
        //for other browsers
        res.left = __parseBorderWidth(element.style.borderLeftWidth);
        res.top = __parseBorderWidth(element.style.borderTopWidth);
        res.right = __parseBorderWidth(element.style.borderRightWidth);
        res.bottom = __parseBorderWidth(element.style.borderBottomWidth);
    }
   
    return res;
}


//returns the absolute position of some element within document
function getElementAbsolutePos(elemID) {
    var element;
    if (typeof(elemID) == "string")    {
        element = document.getElementById(elemID);
    }
    else {
        element = elemID;
    }

    var res = new Object();
    res.x = 0; res.y = 0;
    if (element !== null) {
        if (__isIENew) {
            res.x = element.scrollLeft;
            res.y = element.scrollTop;
        }
        else {
            res.x = element.offsetLeft;
            res.y = element.offsetTop;
        }
        
        var offsetParent = element.offsetParent;
        var parentNode = element.parentNode;
        var borderWidth = null;

        while (offsetParent != null) {
            res.x += offsetParent.offsetLeft;
            res.y += offsetParent.offsetTop;
            
            var parentTagName = offsetParent.tagName.toLowerCase();    

            if ((__isIEOld && parentTagName != "table") || (__isFireFoxNew && parentTagName == "td")) {            
                borderWidth = __getBorderWidth(offsetParent);
                res.x += borderWidth.left;
                res.y += borderWidth.top;
            }
            
            if (offsetParent != document.body && offsetParent != document.documentElement) {
                res.x -= offsetParent.scrollLeft;
                res.y -= offsetParent.scrollTop;
            }


            //next lines are necessary to support FireFox problem with offsetParent
               if (!__isIE && !__isOperaOld || __isIENew) {
                while (offsetParent != parentNode && parentNode !== null) {
                    res.x -= parentNode.scrollLeft;
                    res.y -= parentNode.scrollTop;
                    if (__isFireFoxOld && __isWebKit) {
                        borderWidth = __getBorderWidth(parentNode);
                        res.x += borderWidth.left;
                        res.y += borderWidth.top;
                    }
                    parentNode = parentNode.parentNode;
                }    
            }

               parentNode = offsetParent.parentNode;
            offsetParent = offsetParent.offsetParent;
        }
    }
    return res;
}

