/* zobrazeni polohy telesa na ekliptice */
var EcliView =
    {
    icon:"../gfx/ecliviewIcon.png", 
    caption:"ekliptika", 

    help: "Orientační zobrazení <b>polohy objektu na ekliptikální mapě</b> spolu se Sluncem a Měsícem (<i>tam kde to dává smysl</i>). Poklikem na tabulku <b>zafixujete</b> daný řádek.",


    parameters:""
    };
    
// OBSAH
EcliView.content=function () 
    {
    return '\
            <img src="../gfx/ecliview.png" border="0" width="1024" height="266" alt="ekliptika"> \
            <img id="EcliViewSun" src="../gfx/sun.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:30px;left:30px"> \
            <img id="EcliViewMoon" src="../gfx/moon.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:30px;left:60px;"> \
            <img id="EcliViewTarget" src="../gfx/target.png" border="0" width="20" height="20" alt="otacivka" style="position:absolute;top:30px;left:90px;"> \
            ';
    
    
    }


// ODKAZY NA ELEMENTY
EcliView.sun = null;
EcliView.moon = null;
EcliView.target = null;


// CORE
// rozmer pole 982x202
// meritko v deklinace 23.5st = 68px
// pocatek: 1021x 105y

EcliView.setPos =function (target,ra,dec)
    {
    target.style.left = 1021-(ra*2.7277)+'px'; // 982/360=2.727
    target.style.top =  125-(dec*3.5)+'px';  // 23.5/68
    }





  
// HANDLERS
EcliView.onShow=function ()
    {
    EcliView.sun = document.getElementById('EcliViewSun'); 
    EcliView.moon = document.getElementById('EcliViewMoon'); 
    EcliView.target = document.getElementById('EcliViewTarget'); 
    
    EcliView.moon.style.display = (EcliView.parameters.showMoon)?"block":"none";
    EcliView.sun.style.display = (EcliView.parameters.showSun)?"block":"none";
    }

EcliView.onHide=function () {} 

EcliView.interactionHandler=function (sender,type)
    {
    switch(type)
        {
        case 1: // onMouseOver
            {
            // sunmoon
            sm = sender.getAttribute('sunmoon');
            this.setPos(EcliView.sun,eval(sm.substr(0,3)),eval(sm.substr(3,3)));
            this.setPos(EcliView.moon,eval(sm.substr(6,3)),eval(sm.substr(9,3)));

            // nasati dat
            var r = Number(sender.getAttribute('id').substring(1)); // id radky je ve formatu r00
            var par = this.parameters;
            var format = this.parameters.format;
            var ra  = decode(document.getElementById('c'+r+'_'+par.raCol).innerHTML,par.raFormat);
            var dec = decode(document.getElementById('c'+r+'_'+par.decCol).innerHTML,par.decFormat);
            this.setPos(this.target,ra*15,dec);
            
            break;
            }
        
        }


    } 

