/* přepočet časů východu, západu a průchodu pro jinou geografickou polohu */


var Geo =
    {
    icon:"../gfx/geoIcon.png", 
    caption:"východ-západ<br>průchod", 
    
    help: "Přibližný <b>přepočet časů východu, průchodu a západu</b> vzhledem k zeměpisné poloze. Algoritmus je uveden v kapitole Slunce resp. Měsíc. Polohu zvolte poklikem na mapu. Poklikem na tabulku <b>zafixujete</b> daný řádek.",


    phiField: null,      // policka pro zobrazeni souradnic
    lambdaField: null,

    riseField: null,  // policka pro zapad/pruchod/vychod
    topField: null, 
    setField: null, 

    rise: -1,  // zapad/pruchod/vychod - hodnoty z tabulky
    top: -1, 
    set: -1, 
    az: 0, 

    phi: 50,     // souradnice
    lambda: 15, 
    
    latLine: null,
    longLine: null,
    map: null,

    parameters:""
        // riseCol,topCol,setCol ~ sloupce tabulky ve kterých jsou data
        // azCol ~ sloupec s azimutem (západu) ... není-li definován (=0) používá se algoritmus bez azimutu
        // formatRS ~ formát dat západu a východu (viz. dencoder)
        // formatT ~ formát dat průchodu (viz. dencoder)

    };
    
// OBSAH
Geo.content=function () 
    {
    var out = '<div id="geo">';
    out += '<div class="title">východ&nbsp;průchod&nbsp;západ</div>';
    out+='<div><img src="../gfx/horizon.png" border="0" width="330" height="99"></div>\n';
    out+='<div id="geoMap">';
    out+='<div id="geoRise" class="fields" style="top:-70px;left:20px;white-space: pre;">-- --</div>\n';
    out+='<div id="geoTop" class="fields" style="width:70px;top:-58px;left:120px;white-space: pre;">-- --</div>\n';
    out+='<div id="geoSet" class="fields" style="top:-70px;right:20px;white-space: pre;">-- --</div>\n';
    out+='<div class="coords">&phi;=<span id="geoPhi">50</span>&deg;&nbsp;&nbsp;&nbsp;&lambda;=<span id="geoLambda">15</span>&deg;</div>\n';
    out+='<img  src="../gfx/map.gif" border="0" width="330" height="220" onclick="Geo.mapClick(event);">\n';
    out+='<img id="geoLatLine" src="../gfx/latLine.gif" border="0" width="330" height="1">\n';
    out+='<img id="geoLongLine" src="../gfx/latLine.gif" border="0" width="1" height="220">\n';
    out+="</div>\n";
    out+="</div>\n";
    return out;
    }



    
// aktualizace zobrazeni
Geo.refresh = function()
    {
    var gRise = NaN;
    var gTop = NaN;
    var gSet = NaN;
    
    if(Geo.rise!=-1) // pokud jeste nebyl zvolen radek tabulky nic nepocitej
    {
    // vypocet hodnot
    if(Geo.az)
        {
        // algoritmus s azimutem (Slunce)
        M = 4*(15-Geo.lambda)/60; // první korekční člen
        N = 6.22*(Geo.phi-50)/Math.tan(Geo.az*Math.PI/180)/60; //druhý korekční člen
        }
        else
        {
        // algoritmus bez azimutu (ostatní)
        M = 4.14*(15-Geo.lambda)/60;
        
        var topPlus = (Geo.rise>Geo.top)?Geo.top+24:Geo.top; // preteceni
        var t = 14.49*(Geo.rise-topPlus);
        if(isNaN(t)) { // napr. u mesice nemusi byt vychod definovany :(
                        topPlus = (Geo.top>Geo.set)?Geo.top+24:Geo.top; // preteceni
                        t = 14.49*(topPlus-Geo.set);
                     } 
                                            
        N = 6.22*(50-Geo.phi)/Math.tan(t*Math.PI/180)/60; //druhý korekční člen
        }
    
    gRise= Normalize(Geo.rise + M + N,24);
    gTop = Normalize(Geo.top + M,24);
    gSet = Normalize(Geo.set + M - N,24);
    }
    


    // zapsani do policek
    Geo.riseField.innerHTML = encode(gRise,this.parameters.formatRS);
    Geo.topField.innerHTML = encode(gTop,this.parameters.formatT);
    Geo.setField.innerHTML = encode(gSet,this.parameters.formatRS);
    
    //Geo.topField.innerHTML = (M*60).toString();
    //Geo.setField.innerHTML = (N*60).toString();
    }
    
    
// mysovite HANDLERY
Geo.mapClick = function(event) // click ~ urceni pozice v mape
    {
    var x = 0;
    var y = 0;
    
    // urceni pozice
    if(event.offsetX)
        { // MSIE, Opera
        x = event.offsetX;
        y = event.offsetY;
        }
        else
        { // Firefox
        pos = getElementAbsolutePos("geoMap"); 

        x = event.pageX-pos.x;
        y = event.pageY-pos.y;
        
        x = x - window.pageXOffset;
        y = y - window.pageYOffset;
        
        }
    
    x--;
    y--;
    
    // kriz
    Geo.longLine.style.left = x.toString()+'px';
    Geo.latLine.style.top = y.toString()+'px';
    
    // souradnice
        // rozmery mapy 330x220px
        // rozsahy lat = 48.27-51.35    long=11.86-19.11
        // meritko lat: 0.014 deg/pixel  long: 0.021 deg/pixel
    Geo.phi = 51.35-(y*0.014);
    Geo.lambda = (x*0.021)+11.86;
    
    Geo.phiField.innerHTML = Geo.phi.toFixed(2);
    Geo.lambdaField.innerHTML = Geo.lambda.toFixed(2);
    
    Geo.refresh();
    }
    
    
  
// module HANDLERY
Geo.onShow=function ()
    {

    this.riseField = document.getElementById('geoRise');
    this.topField = document.getElementById('geoTop');
    this.setField = document.getElementById('geoSet');

    this.phiField = document.getElementById('geoPhi');
    this.lambdaField = document.getElementById('geoLambda');

    this.latLine = document.getElementById('geoLatLine');
    this.longLine = document.getElementById('geoLongLine');

    this.map = document.getElementById('geoMap');

    // init
    this.phi = 50;
    this.lambda = 15;
    
    Geo.longLine.style.left = '149px';
    Geo.latLine.style.top = '97px';

    }

Geo.onHide=function ()
    {
    } 

Geo.interactionHandler=function (sender,type)
    {
    // reset
    this.rise = 0;
    this.top = 0;
    this.set = 0;

    var r = Number(sender.getAttribute('id').substring(1)); // id radky je ve formatu r00

     
     // nasati dat
    var par = this.parameters;
    this.rise = decode(document.getElementById('c'+r+'_'+par.riseCol).innerHTML,this.parameters.formatRS);
    this.top = decode(document.getElementById('c'+r+'_'+par.topCol).innerHTML,this.parameters.formatT);
    this.set = decode(document.getElementById('c'+r+'_'+par.setCol).innerHTML,this.parameters.formatRS);
    if(par.azCol>0)
        {
        this.az = decode(document.getElementById('c'+r+'_'+par.azCol).innerHTML,'f');
        }
    // vykresleni
    this.refresh();
     
    } 

    
    
/* =========================== get element position ======================== */
/* by Sergiy Korzh, http://blogs.korzh.com */

function __getIEVersion() {
    var rv = -1; // Return value assumes failure.
    if (navigator.appName == 'Microsoft Internet Explorer') {
        var ua = navigator.userAgent;
        var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null)
            rv = parseFloat(RegExp.$1);
    }
    return rv;
}

function __getOperaVersion() {
    var rv = 0; // Default value
    if (window.opera) {
        var sver = window.opera.version();
        rv = parseFloat(sver);
    }
    return rv;
}

var __userAgent = navigator.userAgent;
var __isIE =  navigator.appVersion.match(/MSIE/) != null;
var __IEVersion = __getIEVersion();
var __isIENew = __isIE && __IEVersion >= 8;
var __isIEOld = __isIE && !__isIENew;

var __isFireFox = __userAgent.match(/firefox/i) != null;
var __isFireFoxOld = __isFireFox && ((__userAgent.match(/firefox\/2./i) != null) || (__userAgent.match(/firefox\/1./i) != null));
var __isFireFoxNew = __isFireFox && !__isFireFoxOld;

var __isWebKit =  navigator.appVersion.match(/WebKit/) != null;
var __isChrome =  navigator.appVersion.match(/Chrome/) != null;
var __isOpera =  window.opera != null;
var __operaVersion = __getOperaVersion();
var __isOperaOld = __isOpera && (__operaVersion < 10);

function __parseBorderWidth(width) {
    var res = 0;
    if (typeof(width) == "string" && width != null && width != "" ) {
        var p = width.indexOf("px");
        if (p >= 0) {
            res = parseInt(width.substring(0, p));
        }
        else {
             //do not know how to calculate other values (such as 0.5em or 0.1cm) correctly now
            //so just set the width to 1 pixel
            res = 1; 
        }
    }
    return res;
}


//returns border width for some element
function __getBorderWidth(element) {
    var res = new Object();
    res.left = 0; res.top = 0; res.right = 0; res.bottom = 0;
    if (window.getComputedStyle) {
        //for Firefox
        var elStyle = window.getComputedStyle(element, null);
        res.left = parseInt(elStyle.borderLeftWidth.slice(0, -2));  
        res.top = parseInt(elStyle.borderTopWidth.slice(0, -2));  
        res.right = parseInt(elStyle.borderRightWidth.slice(0, -2));  
        res.bottom = parseInt(elStyle.borderBottomWidth.slice(0, -2));  
    }
    else {
        //for other browsers
        res.left = __parseBorderWidth(element.style.borderLeftWidth);
        res.top = __parseBorderWidth(element.style.borderTopWidth);
        res.right = __parseBorderWidth(element.style.borderRightWidth);
        res.bottom = __parseBorderWidth(element.style.borderBottomWidth);
    }
   
    return res;
}


//returns the absolute position of some element within document
function getElementAbsolutePos(elemID) {
    var element;
    if (typeof(elemID) == "string")    {
        element = document.getElementById(elemID);
    }
    else {
        element = elemID;
    }

    var res = new Object();
    res.x = 0; res.y = 0;
    if (element !== null) {
        if (__isIENew) {
            res.x = element.scrollLeft;
            res.y = element.scrollTop;
        }
        else {
            res.x = element.offsetLeft;
            res.y = element.offsetTop;
        }
        
        var offsetParent = element.offsetParent;
        var parentNode = element.parentNode;
        var borderWidth = null;

        while (offsetParent != null) {
            res.x += offsetParent.offsetLeft;
            res.y += offsetParent.offsetTop;
            
            var parentTagName = offsetParent.tagName.toLowerCase();    

            if ((__isIEOld && parentTagName != "table") || (__isFireFoxNew && parentTagName == "td")) {            
                borderWidth = __getBorderWidth(offsetParent);
                res.x += borderWidth.left;
                res.y += borderWidth.top;
            }
            
            if (offsetParent != document.body && offsetParent != document.documentElement) {
                res.x -= offsetParent.scrollLeft;
                res.y -= offsetParent.scrollTop;
            }


            //next lines are necessary to support FireFox problem with offsetParent
               if (!__isIE && !__isOperaOld || __isIENew) {
                while (offsetParent != parentNode && parentNode !== null) {
                    res.x -= parentNode.scrollLeft;
                    res.y -= parentNode.scrollTop;
                    if (__isFireFoxOld && __isWebKit) {
                        borderWidth = __getBorderWidth(parentNode);
                        res.x += borderWidth.left;
                        res.y += borderWidth.top;
                    }
                    parentNode = parentNode.parentNode;
                }    
            }

               parentNode = offsetParent.parentNode;
            offsetParent = offsetParent.offsetParent;
        }
    }
    return res;
}

