/* interpolace v tabulkach */


var Interpolator =
    {
    icon:"../gfx/interpolatorIcon.png", 
    caption:"interpolátor", 
    
    help: "Aplikace <b>interpoluje</b> mezi daty ve zvoleném a následujícím řádku tabulky. Okamžik iterpolace se volí pomocí <b>horizontální stupnice</b>. Alternativně lze zadat údaj i <b>číselně</b> poklikem na pole pod ní. Poklikem na stupnici či na řádek tabulky se pozice <b>zafixuje</b>.",
    

    fixedFrame: null, //  policko zafixovane stiskem mysi
    valFields: [], //  pole odkazu na policka tabulky hodnot

    dateFrom: 0, // timestampy začátku a konce intervalu
    dateTo: 0,
    from: [],   // pole hodnot mezi kterými se interpoluje
    to: [],

    pos:0, // pozice [0-1] ke ktere se provadi interpolace

    inputButton:null, // odkaz na tlačítko (pro schovávání)
    inputActive:false, // příznak jestli je zadávání aktivní (kvůli zacyklení .onchange)
    parameters:""
        // columns: [název,formát], ... [-,-] pokud se sloupec neinterpoluje
        // timeback: =true,  
    
    };
    
// datumove funkce
function printDate(t)   // dd.mm.yyyy   t [int] ... PHP.time() tj. počet sec od 1.1.1970
{
    if(isNaN(t)) {return '00-00-0000 00:00';}
    d = new Date();
    d.setTime(t+'000');
    return d.getDate()+"."+(d.getMonth()+1)+"."+d.getFullYear();
}
function printDateTime(t,forceSec)   // dd.mm.yyyy hh:mm[:ss] t [int] ... PHP.time() tj. počet sec od 1.1.1970
{ 
    if(isNaN(t)) {return '00-00-0000 00:00';}
    d = new Date();
    d.setTime(t+'000');
    var sec = d.getSeconds();
    sec = ((sec>0)||forceSec)?":"+('0'+sec).substr(-2,2):"";
    return d.getDate()+"."+(d.getMonth()+1)+"."+d.getFullYear()+' '+d.getHours()+":"+('0'+d.getMinutes()).substr(-2,2)+sec;
}
    
    
// OBSAH
Interpolator.content=function () 
    {
    var out = '<div id="interpolator">';
    out += '<div class="title">Interpolátor</div>';
    // ---------- selector
    out+='\n<table border="0" class="interSelector">\n';
    out+='<tr><th colspan="12"><img src="../gfx/arrow-l.png" border="0" width="15" height="8"><span id="interFromDate">00.00.0000</span></th><th></th><th colspan="12" align="right"><span id="interToDate">00.00.0000</span><img src="../gfx/arrow-r.png" border="0" width="15" height="8"></th></tr>\n';
    out+='<tr>\n';
    for(var i=0;i<=24;i++){
        out+='<td ipos="'+i+'" onmouseover="Interpolator.over(this)" onmouseout="Interpolator.out(this)" onclick="Interpolator.click(this)">&nbsp;</td>\n';
        }
    out+='</tr>\n';
    out+='<tr><th colspan="25" align="center">';
    out+='<input type="text" value="00.00.0000 00:00" id="interDate" size="20" maxlength="20" onfocus="Interpolator.inputFocus()" onchange="Interpolator.inputChange()">';
    out+='<input type="submit" value="Nastavit" id="setDateButton" onclick="Interpolator.inputChange()" style="display:none;border:none;">';
    out+='</th></tr>\n';
    out+="</table>\n";

    // ---------- data table
    out += '<table class="interData">';
    
    var cols = this.parameters.columns;
    for(var i=0;i<cols.length;i++)
        {
        if(cols[i][0]!="-")
            { out=out+"<tr><th>"+cols[i][0]+':</th><td id="ival'+i+'">-</td></tr>';}
        }
    out+="</table>\n";
    // ----------------
    out+="</div>\n";
    return out;
    }


// interpolátor
Interpolator.interpolate = function(xfrom,xto,format)
    {
    var out = 0;
    var overflow = 0;
    
    switch(format) // podle formatu se urci zaklad
                {
                case "hm":
                case "hms":
                    if((xfrom-xto)>12) {overflow=24;break;}
                case "f360":
                    if((xfrom-xto)>180) {overflow=360;break;}
                }
    
    
    if((overflow>0) // pokud se jedna o :cyklickou: velicinu
      &&
      (Math.abs(xfrom-xto)>(overflow/2))) // dojde k prelezeni nuly? (vzdy se interpoluje tou "kratsi cestou)
            {
            if(xfrom>xto)
                { /* prelezam nulu zdola */ xto = xto + overflow; }
                else
                { /* prelezam nulu shora */ xfrom = xfrom + overflow;}
            out=xfrom+Number(this.pos)*(xto-xfrom);
            out=Normalize(out,overflow);
            }
            else
            {
            // bez pretekani pres nulu
            out=xfrom+Number(this.pos)*(xto-xfrom);
            }
    return out;
    }

    
// manipulace s tabulkou dat
Interpolator.refresh = function (sender) // aktualizuje tabulku hodnot
    {
    var cols = this.parameters.columns;

    this.dateField.value = printDateTime(this.interpolate(this.dateFrom,this.dateTo));

    for(var i=0;i<cols.length;i++)
        { if(cols[i][1]!="-")
            {
            var format = cols[i][1];
            this.valFields[i].innerHTML = encode(this.interpolate(this.from[i],this.to[i],format),format);
            //this.valFields[i].innerHTML = encode(this.from[i],cols[i][1]);
            }
        }
    }

Interpolator.blind =function () // smaze tabulku hodnot
    {
    var cols = this.parameters.columns;
    for(var i=0;i<cols.length;i++)
        { if(cols[i][1]!="-")
            {
            this.valFields[i].innerHTML = '-';
            }
        }
    }

// handlery od textoveho pole

Interpolator.inputFocus = function()
    {
    this.inputActive = true;
    this.dateField.value = printDateTime(this.interpolate(this.dateFrom,this.dateTo),true);  //pridej sekundy
    this.inputButton.style.display="inline"; // zobraz tlacitko
    }   
Interpolator.inputChange = function()
    {
    if(!this.inputActive) {return;} // nebylo-li zadavani aktivni, pryc! (= .onchange cyklus)

    this.inputButton.style.display="none";

    //rozsekej na cisla a vytvor stamp
    var regexp = /([0-9]+)/g;
    var ex = this.dateField.value.match(regexp);
    ex[5] = isNaN(ex[5])?0:ex[5];
    var d = new Date(ex[2],ex[1]-1,ex[0],ex[3],ex[4],ex[5]);
    
    // JS stamp -> PHP stamp
    var dd = d.valueOf()/1000;
    if((dd>=this.dateFrom)&&(dd<=this.dateTo))
        // v rozsahu
        {
        this.pos = (dd-this.dateFrom)/(this.dateTo-this.dateFrom);
        this.refresh();
        
        }
        else
        // mimo
        {
            alert("Datum/čas je mimo rozsah zvolených řádků \n"+printDateTime(dd));
            this.blind();
        }


    }   

    
// mysovite HANDLERY
Interpolator.over = function(sender) // prejezd mysi ~ nova pozice
    {
    if(!this.dateFrom) { return; }
    if(!this.fixedFrame)
        {
            this.pos = sender.getAttribute('ipos')/24;
            sender.style.backgroundColor="#ffb0b0";
            this.refresh();
        }
    }
    
Interpolator.out = function(sender)  // odjezd
    {
    if(!this.fixedFrame)
        { sender.style.backgroundColor="#f8f880"; this.pos=0;}
    }
    
Interpolator.click = function(sender) // click ~ zafixovani pozice
    {
    if(this.fixedFrame)
        { // release
        var ff = this.fixedFrame;
        this.fixedFrame = null;
        this.out(ff);
        this.over(sender);
        }    
        else
        { // fix
        this.fixedFrame = sender;
        sender.style.backgroundColor="lime";
        }
    
    }
    
    


  
// module HANDLERY
Interpolator.onShow=function ()
    {
    this.fixedFrame = null;

    this.valFields = new Array();
    var cols = this.parameters.columns;
    for(var i=0;i<cols.length;i++)
        {
        // index tabulky výstupních hodnot
        if(cols[i][1]!="-")
            {
            this.valFields[i] = document.getElementById('ival'+i); 
            }
        }
        
    this.dateFromField = document.getElementById('interFromDate');
    this.dateToField = document.getElementById('interToDate');
    this.dateField = document.getElementById('interDate');
    this.inputButton = document.getElementById('setDateButton');
    
    }

Interpolator.onHide=function ()
    {
    this.dateFrom = 0;
    this.dateTo = 0;
    } 

Interpolator.interactionHandler=function (sender,type)
    {
    // reset
    this.from = new Array();
    this.to = new Array();

     // zakladni datum/cas
     this.dateFrom = Number(sender.getAttribute('date'));

     // datum/cas na dalsim radku
     var r1 = Number(sender.getAttribute('id').substring(1)); // id radky je ve formatu r00
     var r2 = r1+1;
     var nextRow = document.getElementById('r'+ r2);
     this.dateTo = nextRow?Number(nextRow.getAttribute('date')):0;

     if(!nextRow)
        {
        this.blind();
        this.dateFromField.innerHTML = printDate(this.dateFrom);
        this.dateToField.innerHTML = '--.--.----';
        return;
     }

     // ukazatele rozsahu
     this.dateFromField.innerHTML = printDate(this.dateFrom);
     this.dateToField.innerHTML = printDate(this.dateTo);
     
     // nasati dat
    var cols = this.parameters.columns;
    for(var i=0;i<cols.length;i++)
        { if(cols[i][1]!="-")
            {
            var format = cols[i][1];
            this.from[i] = decode(document.getElementById('c'+r1+'_'+i).innerHTML,format);
            this.to[i] = decode(document.getElementById('c'+r2+'_'+i).innerHTML,format);
            }
        }
        
    // vykresleni
    this.refresh();
     
    } 



