/*
============================================= DE/ENCODER
--- univerzální číselný decoder/encoder pro tabulky HR ---
převádí čísla na základě formátu ze stringu a zpátky

formáty:
    hms - hodiny minuty sekundy
    hms3 - hodiny minuty sekundy (3 desetinna mista)
    hm - hodiny minuty
    ms - minuty sekundy
    sdm - znaménko (mezera?) stupně minuty
    sdms - znaménko (mezera?) stupně minuty sekundy
    f - obyčejný float
    f3 - float, 3 desetinna mista

*/


function Normalize(h,base)
    {
    if(h>base) {h=h-base;}
    if(h<0) {h=h+base;}
    return h;   
    }

function trim(s) {
                return String(s).replace(/^\s+|\s+$/g,"");
                }


function decode(s,format)
{
var out;
//s=s.replace(/^\s+|\s+$/g,""); // trim
switch(format)
    {
    case "hm":
    case "ms":
    case "ms3":
        var regexp = /[ ]*([0-9.,]+)/g;
        var ex = s.match(regexp);
        out = ex?parseFloat(ex[0])+parseFloat((ex[1])/60):NaN;
        break;
    case "hms":
    case "hms3":
        var regexp = /[ ]*([0-9.,]+)/g;
        var ex = s.match(regexp);
        out = ex?parseFloat(ex[0])+parseFloat((ex[1])/60)+parseFloat((ex[2])/3600):NaN;
        break;
    case "sdm":
        s = trim(s);
        var regexp = /[0-9.,]+/g;
        var ex = s.match(regexp);
        out = ex?parseFloat(ex[0])+parseFloat((ex[1])/60):NaN;
        out=(s.charAt(0)=='-')?-out:out;
        break;
    case "sdms":
        s = trim(s);
        var regexp = /[0-9.,]+/g;
        var ex = s.match(regexp);
        out = ex?parseFloat(ex[0])+parseFloat((ex[1])/60)+parseFloat((ex[2])/3600):NaN;
        out=(s.charAt(0)=='-')?-out:out;
        break;

    case "f":
    case "f3":
    case "f5":
    case "f360":
        out = parseFloat(s);
        break;
        
        
    // ----        
    default: out = parseFloat(s); break;
    }
//ticker.value = s+' '+format+' '+out;  
return out;
}
// -------------------------------------------
function encode(x,format)
{
var out='- f -'; // neznamy format
if(isNaN(x)) { return '-x-'; } // NaN
switch(format)
    {
    case "hm":
    case "ms":
            var h = Math.floor(x);
            var m = (x-h)*60;
            out = h.toString()+' '+m.toFixed(1);
            break;
    case "ms3":
            var h = Math.floor(x);
            var m = (x-h)*60;
            out = h.toString()+' '+m.toFixed(3);
            break;
    case "hms":
    case "hms3":
            var h = Math.floor(x);
            var mx = (x-h)*60;
            var m = Math.floor(mx);
            var s = (mx-m)*60;
            var precision = (format=="hms3")?3:1;
            out = h.toString()+' '+m.toFixed(0)+' '+s.toFixed(precision);
            break;
    case "sdm":
            var abs = Math.abs(x)
            var h = Math.floor(abs);
            var m = (abs-h)*60;
            out = h.toString()+' '+m.toFixed(1);
            out = (x<0?'-':'+')+out;
            break;
    case "sdms":
            var abs = Math.abs(x)
            var h = Math.floor(abs);
            var mx = (abs-h)*60;
            var m = Math.floor(mx);
            var s = (mx-m)*60;
            out = h.toString()+' '+m.toFixed(0)+' '+s.toFixed(1);
            out = (x<0?'-':'+')+out;
            break;
    case "f":
    case "f360":
            out = x.toFixed(1);
            break;
    case "f3":
            out = x.toFixed(3);
            break;
    case "f5":
            out = x.toFixed(5);
            break;
    }
return out;  
    
}
    


